'/***
'*sys/stat.h - defines structure used by stat() and fstat()
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       This file defines the structure used by the _stat() and _fstat()
'*       routines.
'*       [System V]
'*
'*       [Public]
'*
'****/

#If Not %Def(%STAT_INC)
    %STAT_INC = 1

'#include <sys/types.h>
'typedef long time_t;
'typedef unsigned short _ino_t;          /* i-node number (not used on DOS) */
'typedef unsigned int _dev_t;            /* device code */
'typedef long _off_t;                    /* file offset value */
'typedef unsigned short wchar_t;

'/* define structure for returning status information */

#If Not %Def(%STAT_DEFINED)
%STAT_DEFINED = 1

Type tag_stat            ' stat
   st_dev   As Dword     ' _dev_t
   st_ino   As Word      ' _ino_t
   st_mode  As Word      ' unsigned short
   st_nlink As Integer   ' short
   st_uid   As Integer   ' short
   st_gid   As Integer   ' short
   st_rdev  As Dword     ' _dev_t
   st_size  As Long      ' _off_t
   st_atime As Long      ' time_t
   st_mtime As Long      ' time_t
   st_ctime As Long      ' time_t
End Type

'#IF %INTEGRAL_MAX_BITS >= 64
Type tag_stati64         ' stati64
   st_dev   As Dword     ' _dev_t
   st_ino   As Word      ' _ino_t
   st_mode  As Word      ' unsigned short
   st_nlink As Integer   ' short
   st_uid   As Integer   ' short
   st_gid   As Integer   ' short
   st_rdev  As Dword     ' _dev_t
   st_size  As Quad      ' __int64
   st_atime As Long      ' time_t
   st_mtime As Long      ' time_t
   st_ctime As Long      ' time_t
End Type
'#ENDIF

#EndIf


%S_IFMT       = 0170000         ' /* file type mask */
%S_IFDIR      = 0040000         ' /* directory */
%S_IFCHR      = 0020000         ' /* character special */
%S_IFIFO      = 0010000         ' /* pipe */
%S_IFREG      = 0100000         ' /* regular */
%S_IREAD      = 0000400         ' /* read permission, owner */
%S_IWRITE     = 0000200         ' /* write permission, owner */
%S_IEXEC      = 0000100         ' /* execute/search permission, owner */


'/* Function prototypes */

'_CRTIMP int __cdecl _fstat(int, struct _stat *);
Declare Function fstat CDecl Lib "msvcrt.dll" Alias "_fstat" ( _
   ByVal Long, _                            ' fd
   ByRef tag_stat _                         ' struct _stat *buffer
   ) As Long                                ' int

'_CRTIMP int __cdecl _stat(const char *, struct _stat *);
Declare Function stat CDecl Lib "msvcrt.dll" Alias "_stat" ( _
   ByRef Asciiz, _                          ' const char *path
   ByRef tag_stat _                         ' struct _stat *buffer
   ) As Long                                ' int

'#if     _INTEGRAL_MAX_BITS >= 64
'_CRTIMP int __cdecl _ftag_stati64(int, struct _tag_stati64 *);
Declare Function fstati64 CDecl Lib "msvcrt.dll" Alias "_fstati64" ( _
   ByVal Long, _                            ' fd
   ByRef tag_stati64 _                      ' struct _tag_stati64 *buffer
   ) As Long                                ' int

'_CRTIMP int __cdecl _tag_stati64(const char *, struct _tag_stati64 *);
Declare Function stati64 CDecl Lib "msvcrt.dll" Alias "_stati64" ( _
   ByRef Asciiz, _                          ' const char *path
   ByRef tag_stati64 _                      ' struct _tag_stati64 *buffer
   ) As Long                                ' int
'#endif

#If Not %Def(%WSTAT_DEFINED)
%WSTAT_DEFINED = 1

'/* wide function prototypes, also declared in wchar.h  */

'_CRTIMP int __cdecl _wstat(const wchar_t *, struct _stat *);
Declare Function wstat CDecl Lib "msvcrt.dll" Alias "_wstat" ( _
   ByVal Dword, _                           ' const wchar_t *path
   ByRef tag_stat _                         ' struct _stat *buffer
   ) As Long                                ' int

'#if     _INTEGRAL_MAX_BITS >= 64
'_CRTIMP int __cdecl _wtag_stati64(const wchar_t *, struct _tag_stati64 *);
Declare Function wstati64 CDecl Lib "msvcrt.dll" Alias "_wstati64" ( _
   ByVal Dword, _                           ' const wchar_t *path
   ByRef tag_stati64 _                      ' struct _tag_stati64 *buffer
   ) As Long                                ' int
'#endif

#EndIf   ' #IF NOT %DEF(%WSTAT_DEFINED)


#EndIf   ' #IF NOT %DEF(%STAT_INC)